# finaquant Financial Analytics - www.finaquant.com
# Copyright: Tunc Ali Ktkcoglu  2012, version: 28Mar2012
# Function for Simple Performance Fee Calculation
# Related web page:
# http://finaquant.com/simple-performance-fee-calculation-for-investment-funds/760

SimplePerformanceFee = function(NAVps,BenchmarkReturns,applyHWM,FeeRate,HurdleRate,FloorPs,CapPs) {
#     NAVps,              vector of NAV per share values, length = N+1
#     BenchmarkReturns,   vector of benchmark returns, length = N
#     applyHWM,           true or false, if true apply rHWM condition in calculation
#     FeeRate,            performance fee rate, f.e. 5 for 5%
#     HurdleRate,         hurdle rate, f.e. 5 for 5%
#     FloorPs,            performance fee floor (lower limit) per share
#     CapPs               performance fee cap (higher limit) per share

# check size of vectors
N = length(BenchmarkReturns) + 1
if (length(NAVps) != N) stop('length of NAVps must be 1 plus length of BenchmarkReturns')

# construct benchmark values
BenchmarkValues = convert_Returns_to_AssetValues(NAVps[1], BenchmarkReturns)

# relative values for each period
RelativeValues = NAVps - BenchmarkValues

# calculate fund returns
NAVlen = length(NAVps)
FundReturn = (NAVps[2:NAVlen] - NAVps[1:NAVlen-1]) / NAVps[1:NAVlen-1]

# outperformance
Outperform = FundReturn - BenchmarkReturns

# relative HWM
rHWM = calculate_HWM(RelativeValues)

# excess return
ExcessReturn = Outperform - HurdleRate

	if (applyHWM) {     # apply rHWM condition
		# find period indices where relative value <= rHWM, i.e. rHWM condition not passed
		# remember: N = length(BenchmarkReturns) + 1
		FailedPeriods = which((RelativeValues[2:N] <= rHWM[1:N-1]) == 1)
		FeeBeforeCF[FailedPeriods] = - HurdleRate * NAVps[FailedPeriods] * FeeRate
		
		PassedPeriods = which((RelativeValues[2:N] > rHWM[1:N-1]) == 1);
		# only increased relative value above rHWM count to effective overperformance
		Outperform_rHWM = Outperform[PassedPeriods] * (RelativeValues[PassedPeriods+1] - rHWM[PassedPeriods]) / (RelativeValues[PassedPeriods+1] - RelativeValues[PassedPeriods])
		FeeBeforeCF[PassedPeriods] = (Outperform_rHWM - HurdleRate) * NAVps[PassedPeriods] * FeeRate

	} else {       # don't apply rHWM condition
		FeeBeforeCF = ExcessReturn * NAVps[1:N-1] * FeeRate
	}

# performance fee per share
PerfFeePs = pmax(pmin(FeeBeforeCF, CapPs), FloorPs)

# return all results
return(list(Outperform,FundReturn,ExcessReturn,RelativeValues,rHWM,FeeBeforeCF,PerfFeePs))
}




